<style>
    :root{ --thumb-col: 5%; --gap: 14px; }
    .amz-grid{ display:grid; grid-template-columns: var(--thumb-col) minmax(0,1fr); gap: var(--gap); min-height: 60vh; }
    .amz-grid.single{ grid-template-columns: minmax(0,1fr); }
    .amz-thumbs{ overflow:auto; padding:14px 8px; display:flex; flex-direction:column; gap:8px; min-width:64px; }
    .amz-thumb{ width:50px; height:50px; border-radius:6px; overflow:hidden; background:#fff; border:1px solid #e5e7eb; cursor:pointer; display:grid; place-items:center; }
    .amz-thumb img{ width:50px; height:50px; object-fit:cover; display:block; }
    .amz-thumb.active{ outline:2px solid #0d6efd; outline-offset:2px; }
    .amz-stage{ border-left:1px solid #e5e7eb; background:#fff; min-height:60vh; display:grid; place-items:center; position:relative; }
    .amz-stage img#amz-main{ max-width:95%; max-height:80vh; object-fit:contain; user-select:none; -webkit-user-drag:none; }
    .amz-head{ display:flex; justify-content:space-between; gap:12px; padding:12px 16px; border-bottom:1px solid #e5e7eb; }
    .amz-meta{ color:#6c757d; font-size:.9rem; }
    @media (max-width: 768px){
      :root{ --thumb-col: 100%; }
      .amz-grid{ grid-template-columns: minmax(0,1fr); }
      .amz-thumbs{ flex-direction:row; height:80px; }
      .amz-stage img#amz-main{ max-height:60vh; }
    }
  </style>

  @php
    $items = [];
    foreach ($media as $m) {
      $raw = trim($m->path ?? '');
      $url = null;
      if ($raw !== '') {
        if (preg_match('~^https?://~i', $raw))             $url = $raw;
        elseif (str_starts_with($raw,'public/storage/')) { $p = substr($raw,7); if (file_exists(public_path($p))) $url = asset($p); }
        elseif (str_starts_with($raw,'storage/')) {         if (file_exists(public_path($raw))) $url = asset($raw); }
        else {
          if (\Storage::disk('public')->exists($raw))       $url = \Storage::url($raw);
          elseif (file_exists(public_path($raw)))           $url = asset($raw);
        }
      }
      $items[] = ['id'=>$m->id,'url'=>$url ?: asset('img/placeholder_zapato_detalle.svg'),'is_primary'=>(bool)$m->is_primary];
    }
  @endphp

  <div class="amz-head">
    <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-dismiss="modal">Cerrar</button>
  </div>

  <div class="amz-grid {{ count($items)<=1 ? 'single' : '' }}">
    <div class="amz-thumbs" id="amz-thumbs">
      @foreach($items as $i => $it)
        <div class="amz-thumb {{ $i===$initialIndex ? 'active' : '' }}"
             data-index="{{ $i }}"
             title="#{{ $it['id'] }} {{ $it['is_primary'] ? '(principal)' : '' }}">
          <img src="{{ $it['url'] }}" alt="thumb">
        </div>
      @endforeach
    </div>

    <div class="amz-stage">
      <img id="amz-main" src="{{ $items[$initialIndex]['url'] ?? asset('img/placeholder_zapato_detalle.svg') }}" alt="imagen">
    </div>
  </div>

  <script>
  (function(){
    const items  = @json($items);
    let idx      = Number(@json($initialIndex));
    const main   = document.getElementById('amz-main');
    const thumbs = document.querySelectorAll('.amz-thumb');

    function paint(){
      if (!items.length) return;
      main.src = items[idx].url;
      thumbs.forEach((t,i)=> t.classList.toggle('active', i===idx));
    }

    thumbs.forEach(t=>{
      t.addEventListener('click', ()=>{
        const i = parseInt(t.getAttribute('data-index') || '0', 10);
        idx = i; paint();
      });
    });

    document.addEventListener('keydown', (e)=>{
      const modalOpen = !!document.querySelector('#galleryModal.show');
      if (!modalOpen || !items.length) return;
      if (e.key === 'ArrowLeft')  { idx = (idx - 1 + items.length) % items.length; paint(); }
      if (e.key === 'ArrowRight') { idx = (idx + 1) % items.length; paint(); }
    });

    paint();
  })();
  </script>
